unit aspxDelphiWCL.Common;

interface

uses
   System.Drawing, System.Web, System.Web.UI;

type
  Common = class (System.Object)
    class function IsDesignTime(Page : System.Web.UI.Page) : boolean;
    class function ColorToHex(Color : System.Drawing.Color) : string;

  end;

implementation

{ Common }

class function Common.ColorToHex(Color: System.Drawing.Color): string;
begin
  Result := System.String.Format('#{0:X2}{1:X2}{2:X2}', [Color.R, Color.G, Color.B]);
end;

class function Common.IsDesignTime(Page: System.Web.UI.Page): boolean;
begin
  if NOT Assigned(Page) then
  begin
    Result := True;
    Exit;
  end;

  if Assigned(Page.Site) then
  begin
    Result := Page.Site.DesignMode;
    Exit;
  end;

  Result := False;
end;

end.
